CREATE OR REPLACE FUNCTION public.ufd_est_prod_tbl_desc_classificacao(
	integer, 
	integer, 
	integer, 
	integer, 
	integer, 
	integer, 
	integer
)
RETURNS SETOF public.rs_tab_desc_prod AS
$body$


/*
--<<INICIO DO CORPO DA FUNCAO

=======================================================================================
'Nível Classificação.: INFORMAÇÃO RESTRITA
'Versão..............: 20221106
'Job.................:  
'Nome................:  ufd_est_prod_tbl_desc_classificacao
'Objetivo............: RETORNAR DESCONTOS DO PRODUTO EM TABELA DE DESCONTO
'Tabelas.............: 
'Dt Criação..........: 
'Dt Ult Alteracão....: 2022-11-06
'Alterado por........: Marcos barros
'Criado por..........: FERNANDO JUNIO CUNHA E SOUSA 
'======================================================================================= 

-- Function: select * from ufd_est_prod_tbl_desc_classificacao(1, 1, 1, 1, 1)           
  
 int_cd_emp         --- CODIGO DA EMPRESA  
 int_cd_filial      --- CODIGO DA FILIAL  
 int_cd_prod        --- CODIGO DO PRODUTO  
 int_mes			--- CODIGO DO CLIENTE PARA RETORNO DE DESCONTO PARA CLIENTE 
 int_is_receita     --- CODIGO DO CONVENIO ( CASO SEJA CONVENIADO,SE NAO FOR DEVE-SE PASSAR ZERO)  
 int_is_receita     --- INDICA SE E VENDA COM RECEITA OU NÃO
*/  

--DECLARA AS VARIAVEIS USADAS NA FUNCAO
DECLARE

---------------------------------------------------------
----DECLARA AS VARIAVEIS QUE ESTAO NO CABECALHO DA FUNCAO
---------------------------------------------------------
int_cd_emp              ALIAS FOR $1;
int_cd_filial           ALIAS FOR $2; 
int_cd_prod             ALIAS FOR $3;
int_cli                 ALIAS FOR $4;
int_is_receita          ALIAS FOR $5;
int_cd_forma_pgto       alias for $6;
int_usa_desconto_propz_ident ALIAS FOR $7;

---------------------------------------------------------
---FIM
---------------------------------------------------------

var_trabalhacomdescontoformadepagamento 	integer;

returnRec rs_tab_desc_prod; --RECEBERA OS DADOS DE RETORNO DA FUNCAO
--DECLARANDO VARIAVEL PARA TESTE DA FLAG 

var_class_cli integer;

BEGIN --INICIO DOS BLOCOS DA FUNCAO

	
	-------------------------------------------------------------------------------------------------------------------------------
	--DECLARANDO TABELA TEMPORARIA DE RETORNO
	-------------------------------------------------------------------------------------------------------------------------------
	BEGIN
		CREATE TEMPORARY TABLE temp_rs_tab_desc_classif
		(	
			cd_tbl_desc 		integer,
			tp_desc 			integer,
			flag_desc_fix 		integer,
			perc_desc			double precision,
			perc_desc_max		double precision,
			tp_nivel			integer,
			dt_ini              timestamp without time zone,
			dt_fim              timestamp without time zone
		);
		EXCEPTION WHEN OTHERS THEN
		TRUNCATE TABLE temp_rs_tab_desc_classif; -- TRUNCA A TABELA SE ELA JÁ EXISTIR NA CORRENTE SESSÃO.
	END;
	
	-------------------------------------------------------------------------------------------------------------------------------
	--DECLARANDO TABELA QUE RECEBERA AS TBLS VIGENTES
	-------------------------------------------------------------------------------------------------------------------------------
	BEGIN
		CREATE TEMPORARY TABLE rs_tab_ativa_classif
		(	
			cd_emp 		integer,    
			cd_tbl_desc integer,    
			tp_desc 	integer
		);
		EXCEPTION WHEN OTHERS THEN
		TRUNCATE TABLE rs_tab_ativa_classif; -- TRUNCA A TABELA SE ELA JA EXISTIR NA CORRENTE SESSAO.
	END;
	
	-------------------------------------------------------------------------------------------------------------------------------
	--DECLARANDO TABELA DE ARVORE MERCADOLOGICA DO PRODUTO
	-------------------------------------------------------------------------------------------------------------------------------
	
	BEGIN
		CREATE TEMPORARY TABLE rs_est_prod_arv_merc
		(
			cd_emp					integer,
			cd_prod					integer,
			cd_arv_merc_categ		integer,
			cd_arv_merc_linha		integer,
			cd_mc					integer,
			cd_arv_merc_familia		integer,								
			cd_fabric				integer
		);--fim rs_est_prod_arv_merc
		EXCEPTION WHEN OTHERS THEN
		TRUNCATE TABLE rs_est_prod_arv_merc; -- TRUNCA A TABELA SE ELA JA EXISTIR NA CORRENTE SESSAO.
	END;
	

	-------------------------------------------------------------------------------------------------------------------------------	
	---------------------------------------------------FIM DA CRIACAO DAS TBLS TEMPORARIAS-----------------------------------------
	-------------------------------------------------------------------------------------------------------------------------------

	-------------------------------------------------------------------------------------------------------------------------------
	--BUSCANDO ARVORE MERC. DO PRODUTO
	-------------------------------------------------------------------------------------------------------------------------------	
	INSERT INTO rs_est_prod_arv_merc		
		SELECT 
			arv.cd_emp					,
			arv.cd_prod					,
			arv.cd_arv_merc_categ		,
			arv.cd_arv_merc_linha		,
			arv.cd_mc					,
			arv.cd_arv_merc_familia		,												
			p.cd_fabric 
		FROM 	est_prod_est_arv_mercadologica arv INNER JOIN est_prod p ON
				arv.cd_emp		= p.cd_emp
				AND arv.cd_prod = p.cd_prod
		WHERE   	arv.cd_emp = int_cd_emp
			AND 	arv.cd_prod = int_cd_prod;
	
	-- CAPTURANDO CLASSIFICACAO DO CLIENTE
	var_class_cli = COALESCE((SELECT COALESCE(cd_preco_clas_cliente,0) FROM rc_cli WHERE cd_emp = int_cd_emp AND cd_cli = int_cli) ,0);	
			
	var_trabalhacomdescontoformadepagamento = coalesce((select coalesce(valor,'0')::integer from prc_filial_config where cd_chave = 'USA_DESCONTO_PGTO' and cd_filial = int_cd_filial), 0);		
		
	IF var_class_cli > 0 THEN
	
		IF EXISTS (SELECT 1 FROM rs_est_prod_arv_merc) THEN
		
			-- TODAS AS TABELAS QUE NAO EXITE RECEITA
			INSERT INTO rs_tab_ativa_classif    
				SELECT  a.cd_emp,    
						a.cd_tbl_desc,    
						a.cd_tp_desconto
				FROM est_prod_tbl_desc a INNER JOIN    
				     est_prod_tbl_desc_prc_filial fil ON    
					    a.cd_emp = fil.cd_emp AND    
					    a.cd_tbl_desc = fil.cd_tbl_desc INNER JOIN
					 est_prod_tbl_desc_glb_class_cliente class_cli ON    
						a.cd_emp =  class_cli.cd_emp AND    
						a.cd_tbl_desc = class_cli.cd_tbl_desc  
				WHERE	int_cd_emp = a.cd_emp AND    
						int_cd_filial = fil.cd_filial AND
						CURRENT_DATE BETWEEN date(a.dt_ini) AND date(a.dt_fim) AND
						1 = a.sts_tbl_desc AND    
						12 = a.cd_tp_desconto AND 
						var_class_cli = class_cli.cd_class_cliente AND
						a.flag_desc_receita = 0
						AND	(
					      ((int_usa_desconto_propz_ident = 1) AND (a.flag_tp_desconto_propz = 1)) OR 
					      ((int_usa_desconto_propz_ident = 0) AND (a.flag_tp_desconto_propz <> 1))
					    );
						
			-- INCLUI AS TABELAS QUE EXITE RECEITA			
			IF 	int_is_receita > 0 THEN		
				
				INSERT INTO rs_tab_ativa_classif    
					SELECT  a.cd_emp,    
							a.cd_tbl_desc,    
							a.cd_tp_desconto
					FROM est_prod_tbl_desc a INNER JOIN    
						 est_prod_tbl_desc_prc_filial fil ON    
							a.cd_emp = fil.cd_emp AND    
							a.cd_tbl_desc = fil.cd_tbl_desc INNER JOIN
						 est_prod_tbl_desc_glb_class_cliente class_cli ON    
							a.cd_emp =  class_cli.cd_emp AND    
							a.cd_tbl_desc = class_cli.cd_tbl_desc  
					WHERE	int_cd_emp = a.cd_emp AND  
							int_cd_filial = fil.cd_filial AND
							CURRENT_DATE BETWEEN date(a.dt_ini) AND date(a.dt_fim) AND
							1 = a.sts_tbl_desc AND    
							12 = a.cd_tp_desconto AND 
							var_class_cli = class_cli.cd_class_cliente AND
							a.flag_desc_receita = 1
							AND	(
					          ((int_usa_desconto_propz_ident = 1) AND (a.flag_tp_desconto_propz = 1)) OR 
					          ((int_usa_desconto_propz_ident = 0) AND (a.flag_tp_desconto_propz <> 1))
					        );
			END IF;
		
		if var_trabalhacomdescontoformadepagamento = 1 then  
			 
	
			delete from rs_tab_ativa_classif a 
			 where not exists (select b.cd_emp
			      				 from est_prod_tbl_desc_forma_pgto b  
				    			where b.cd_emp        = a.cd_emp
				    			  and b.cd_tbl_desc   = a.cd_tbl_desc   
				    			  and b.cd_forma_pgto = int_cd_forma_pgto  
				    			    ) ;
	
		end if ; 
		
		
			IF EXISTS (SELECT 1 FROM rs_tab_ativa_classif) THEN
			
				-------------------------------------------------------------------------------------------------------------------------------    
				--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 1 - PRODUTOS    
				-------------------------------------------------------------------------------------------------------------------------------    
				INSERT INTO temp_rs_tab_desc_classif     
					  SELECT    
							a.cd_tbl_desc AS cd_tbl_desc,    
							a.cd_tp_desconto AS tp_desc,    
							a.flag_desc_fix,    
							b.perc_desc AS perc_desc,    
							b.perc_desc_max AS perc_desc_max,    
							1 AS tp_nivel,
							a.dt_ini,
							a.dt_fim
					  FROM est_prod_tbl_desc a    
							INNER JOIN est_prod_tbl_desc_est_prod b ON    
								a.cd_emp = b.cd_emp AND    
								a.cd_tbl_desc = b.cd_tbl_desc    
							INNER JOIN est_prod_tbl_desc_prc_filial fil ON    
								b.cd_emp = fil.cd_emp AND    
								b.cd_tbl_desc = fil.cd_tbl_desc    
							INNER JOIN rs_tab_ativa_classif ON    
								b.cd_emp = rs_tab_ativa_classif.cd_emp AND    
								b.cd_tbl_desc = rs_tab_ativa_classif.cd_tbl_desc     
							INNER JOIN rs_est_prod_arv_merc arv ON    
								b.cd_emp = arv.cd_emp AND    
								b.cd_prod = arv.cd_prod           
					  WHERE     
								int_cd_filial = fil.cd_filial;
								
				-------------------------------------------------------------------------------------------------------------------------------    
				--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 2 - FAMILIAS    
				-------------------------------------------------------------------------------------------------------------------------------    
				INSERT INTO temp_rs_tab_desc_classif     
					SELECT   
							a.cd_tbl_desc AS cd_tbl_desc,    
							a.cd_tp_desconto AS tp_desc,    
							a.flag_desc_fix,    
							b.perc_desc AS perc_desc,    
							b.perc_desc_max AS perc_desc_max,   
							2 AS tp_nivel,
							a.dt_ini,
							a.dt_fim
					FROM Est_prod_tbl_desc a    
							INNER JOIN est_prod_tbl_desc_est_arv_merc_familia b ON    
								a.cd_emp = b.cd_emp AND    
								a.cd_tbl_desc = b.cd_tbl_desc    
							INNER JOIN est_prod_tbl_desc_prc_filial fil ON    
								b.cd_emp = fil.cd_emp AND    
								b.cd_tbl_desc = fil.cd_tbl_desc    
							INNER JOIN rs_est_prod_arv_merc arv ON    
								b.cd_emp = arv.cd_emp AND    
								b.cd_arv_merc_familia = arv.cd_arv_merc_familia    
							INNER JOIN rs_tab_ativa_classif ON    
								a.cd_emp = rs_tab_ativa_classif.cd_emp AND    
								b.cd_tbl_desc = rs_tab_ativa_classif.cd_tbl_desc        
					WHERE     
							int_cd_filial = fil.cd_filial;
							
				-------------------------------------------------------------------------------------------------------------------------------        
				--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 3 - MARCAS    
				-------------------------------------------------------------------------------------------------------------------------------    
				INSERT INTO temp_rs_tab_desc_classif     
					SELECT
							a.cd_tbl_desc AS cd_tbl_desc,    
							a.cd_tp_desconto AS tp_desc,    
							a.flag_desc_fix,    
							b.perc_desc AS perc_desc,    
							b.perc_desc_max AS perc_desc_max,   
							3 AS tp_nivel,
							a.dt_ini,
							a.dt_fim
					FROM est_prod_tbl_desc a    
							INNER JOIN est_prod_tbl_desc_est_mc b ON    
								a.cd_emp = b.cd_emp AND    
								a.cd_tbl_desc = b.cd_tbl_desc    
							INNER JOIN est_prod_tbl_desc_prc_filial fil ON    
								b.cd_emp = fil.cd_emp AND    
								b.cd_tbl_desc = fil.cd_tbl_desc    
							INNER JOIN rs_est_prod_arv_merc arv ON    
								b.cd_emp = arv.cd_emp AND    
								b.cd_mc = arv.cd_mc    
							INNER JOIN rs_tab_ativa_classif ON    
								a.cd_emp = rs_tab_ativa_classif.cd_emp AND    
								b.cd_tbl_desc = rs_tab_ativa_classif.cd_tbl_desc        
					WHERE     
							int_cd_filial = fil.cd_filial;
							
				-------------------------------------------------------------------------------------------------------------------------------    
				--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 4 - FABRICANTES    
				-------------------------------------------------------------------------------------------------------------------------------    
				INSERT INTO temp_rs_tab_desc_classif     
					SELECT   
							a.cd_tbl_desc AS cd_tbl_desc,    
							a.cd_tp_desconto AS tp_desc,    
							a.flag_desc_fix,    
							b.perc_desc AS perc_desc,    
							b.perc_desc_max AS perc_desc_max,   
							4 AS tp_nivel,
							a.dt_ini,
							a.dt_fim
					FROM est_prod_tbl_desc a    
							INNER JOIN est_prod_tbl_desc_est_prod_fabric b ON    
								a.cd_emp = b.cd_emp AND    
								a.cd_tbl_desc = b.cd_tbl_desc    
							INNER JOIN est_prod_tbl_desc_prc_filial fil ON    
								b.cd_emp = fil.cd_emp AND    
								b.cd_tbl_desc = fil.cd_tbl_desc    
							INNER JOIN rs_est_prod_arv_merc arv ON    
								b.cd_emp = arv.cd_emp AND    
								b.cd_fabric = arv.cd_fabric     
							INNER JOIN rs_tab_ativa_classif ON    
								b.cd_emp = rs_tab_ativa_classif.cd_emp AND    
								b.cd_tbl_desc = rs_tab_ativa_classif.cd_tbl_desc        
					WHERE     
							int_cd_filial = fil.cd_filial;
							
				------------------------------------------------------------------------------------------------------------------------------    
				--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 5 - CATEGORIAS   
				-------------------------------------------------------------------------------------------------------------------------------    
				INSERT INTO temp_rs_tab_desc_classif     
					SELECT   
							a.cd_tbl_desc AS cd_tbl_desc,    
							a.cd_tp_desconto AS tp_desc,    
							a.flag_desc_fix,    
							b.perc_desc AS perc_desc,    
							b.perc_desc_max AS perc_desc_max,   
							5 AS tp_nivel,
							a.dt_ini,
							a.dt_fim
					FROM est_prod_tbl_desc a    
							INNER JOIN est_prod_tbl_desc_est_arv_merc_categoria b ON    
								a.cd_emp = b.cd_emp AND    
								a.cd_tbl_desc = b.cd_tbl_desc    
							INNER JOIN est_prod_tbl_desc_prc_filial fil ON    
								b.cd_emp = fil.cd_emp AND    
								b.cd_tbl_desc = fil.cd_tbl_desc    
							INNER JOIN rs_est_prod_arv_merc arv ON    
								b.cd_emp = arv.cd_emp AND    
								b.cd_arv_merc_categ = arv.cd_arv_merc_categ    
							INNER JOIN rs_tab_ativa_classif ON    
								a.cd_emp = rs_tab_ativa_classif.cd_emp AND    
								b.cd_tbl_desc = rs_tab_ativa_classif.cd_tbl_desc        
					WHERE     
							int_cd_filial = fil.cd_filial;
							
				-------------------------------------------------------------------------------------------------------------------------------    
				--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 6 -LINHAS      
				------------------------------------------------------------------------------------------------------------------------------- 
                INSERT INTO temp_rs_tab_desc_classif     
					SELECT   
							a.cd_tbl_desc AS cd_tbl_desc,    
							a.cd_tp_desconto AS tp_desc,    
							a.flag_desc_fix,    
							b.perc_desc AS perc_desc,    
							b.perc_desc_max AS perc_desc_max,   
							6 AS tp_nivel,
							a.dt_ini,
							a.dt_fim
					FROM est_prod_tbl_desc a    
							INNER JOIN est_prod_tbl_desc_est_arv_merc_linha b ON    
								a.cd_emp = b.cd_emp AND    
								a.cd_tbl_desc = b.cd_tbl_desc    
							INNER JOIN est_prod_tbl_desc_prc_filial fil ON    
								b.cd_emp = fil.cd_emp and    
								b.cd_tbl_desc = fil.cd_tbl_desc    
							INNER JOIN rs_est_prod_arv_merc arv ON    
								b.cd_emp = arv.cd_emp AND       
								b.cd_arv_merc_linha = arv.cd_arv_merc_linha    
							INNER JOIN rs_tab_ativa_classif ON    
								a.cd_emp = rs_tab_ativa_classif.cd_emp AND    
								b.cd_tbl_desc = rs_tab_ativa_classif.cd_tbl_desc        
					WHERE     
							int_cd_filial = fil.cd_filial;				
				

			END IF;--IF EXISTS (SELECT 1 FROM rs_tab_ativa_classif) THEN
		END IF; --IF EXISTS (SELECT 1 FROM rs_est_prod_arv_merc) THEN

	END IF; 
	-------------------------------------------------------------------------------------------------------------------------------
	-- RETORNANDO DESCONTO LIMITE (RESULTADO DA FUNCAO)
	-------------------------------------------------------------------------------------------------------------------------------

	FOR returnRec IN 
		SELECT cd_tbl_desc, tp_desc, flag_desc_fix, perc_desc, perc_desc_max, tp_nivel, dt_fim
		  FROM temp_rs_tab_desc_classif 
		 ORDER BY tp_nivel ASC, perc_desc DESC, dt_ini DESC LIMIT 1
	LOOP
		RETURN NEXT returnRec;
	END LOOP;				

	
END; --FIM DOS BLOCOS DA FUNCAO
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
PARALLEL UNSAFE
COST 100 ROWS 1000;

CREATE OR REPLACE FUNCTION public.ufd_est_prod_tbl_desc_classificacao(integer, integer, integer, integer, integer, integer)
RETURNS SETOF public.rs_tab_desc_prod AS
$body$
DECLARE RET rs_tab_desc_prod;
BEGIN
  RET = ufd_est_prod_tbl_desc_classificacao($1, $2, $3, $4, $5, $6, 0);
  RETURN NEXT RET;
END
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
PARALLEL UNSAFE
COST 100 ROWS 1000;